<?php

class Bookings_model extends CI_Model {

    function __construct()
    {
        parent::__construct();
        $this->load->library("Forecast_charges");   
    }
    
    //get booking table based on filters
    //elements of the filter array are: start_date, end_date, state, order_by, order, offset, num
    function get_bookings($filters, $company_id = 0, $group_by1 = NULL, $include_room_no_assigned = false, $include_customer_all_details = false)
    {
        if ($company_id == 0)
        {
            $company_id = $this->session->userdata('current_company_id');
        }
        
        $sql = $this->_build_get_bookings_sql_query_based_on_filters($filters, $company_id, $group_by1, $include_room_no_assigned, $include_customer_all_details);

        $q = $this->db->query($sql);    
        
        if ($this->db->_error_message()) 
        {
            show_error($this->db->_error_message());
        }

        $result = $q->result_array();       
        
        return $result;
    }
    
    function _build_get_bookings_sql_query_based_on_filters($filters, $company_id, $group_by1, $include_room_no_assigned = false, $include_customer_all_details = false) 
    {
        $booking_fields_join = $customer_fields_join = '';
        $booking_fields_where_condition = $customer_fields_where_condition = '';

        if(isset($filters['search_query']) && $filters['search_query'])
        {
            $search_query = $filters['search_query'];

            $booking_fields_join = ' LEFT JOIN booking_x_booking_field AS bxbf ON bxbf.booking_id = b.booking_id';
            $booking_fields_where_condition = " OR bxbf.value like '%$search_query%'";
            

            $customer_fields_join = ' LEFT JOIN customer_x_customer_field AS pcxcf ON pcxcf.customer_id = c.customer_id
                                      LEFT JOIN customer_x_customer_field AS scxcf ON scxcf.customer_id = sg.customer_id';
            $customer_fields_where_condition = " OR pcxcf.value like '%$search_query%' OR scxcf.value like '%$search_query%'";
        }

        $where_conditions = $this->_get_where_conditions($filters, $company_id, $include_room_no_assigned, $booking_fields_where_condition, $customer_fields_where_condition);
                
        $where_condition_for_balance = "";
        $where_statement_date = '';
        if(isset($filters['statement_date']) && $filters['statement_date']){
            $where_statement_date = " AND ch.selling_date < '".$filters['statement_date']."' ";
        }
        
        $where_booking_ids = "";
        if(isset($filters['booking_ids']) && $filters['booking_ids']){
            $booking_ids = implode(',', $filters['booking_ids']);
            $where_booking_ids = " AND b.booking_id IN ($booking_ids) ";
        }
        
        if (isset($filters['show_paid'])) 
        {
            if($filters['show_paid'] === "paid_only") 
            {
                $where_condition_for_balance = 'WHERE balance <= 0';
            } 
            elseif ($filters['show_paid'] === "unpaid_only") 
            {
                $where_condition_for_balance = 'WHERE balance > 0';
            }
        }
        

        $order_by = "ORDER BY room_name";
        
        //if both $start and $end are set, then return occupancies within range
        if (isset($filters['order_by'])) 
        {
            if ($filters['order_by'] != "") 
            {
                $order_by = "ORDER BY ".$filters['order_by'];
            }
        }
                
        $group_by = "GROUP BY booking_id";
                if($group_by1){
                    $group_by = $group_by . ' , '.$group_by1;
                }
        if (isset($filters['group_by'])) 
        {
            if ($filters['group_by'] == 'booking_room_history_id')
            {
                $group_by = 'GROUP BY booking_room_history_id';
            }
        }
        
        // set order
        $order = "ASC";
        if (isset($filters['order'])) 
        {
            if ($filters['order'] == 'DESC')
            {
                $order = "DESC";
            }
        }
        
        // set limit
        $limit = "";
        if (isset($filters['offset'])) 
        {
                    $limit = "LIMIT ".intval($filters['offset']);
                    if (isset($filters['per_page'])) 
                    {
                        $limit = $limit.", ".$filters['per_page'];
                    }
                }
        
        $select_statements = $select_group_concat_statements = $join_statements = $where_statements = "";
        if (isset($filters['with_booking_statements']) && $filters['with_booking_statements']) 
        {
            $select_statements = ", x.booking_statements";
            $select_group_concat_statements = ", GROUP_CONCAT(DISTINCT CONCAT( s.statement_id, '_',  s.statement_number)) as booking_statements";
            $join_statements = "LEFT JOIN booking_x_statement AS bs ON bs.booking_id = b.booking_id 
                                LEFT JOIN statement AS s ON bs.statement_id = s.statement_id AND s.is_deleted = 0 ";
        
            if (isset($filters['in_statement']) && $filters['in_statement']) 
            {
                $where_statements .= ' WHERE x.booking_statements IS NOT NULL ';
            }
            elseif (isset($filters['in_statement']) && !$filters['in_statement']) 
            {
                $where_statements .= ' WHERE x.booking_statements IS NULL ';
            }
        }
        
        $include_charge_payment_total = ", IFNULL(
                        (
                            IFNULL(
                                (
                                    SELECT SUM(p.amount) as payment_total
                                    FROM payment as p, payment_type as pt
                                    WHERE
                                        p.is_deleted = '0' AND
                                        pt.is_deleted = '0' AND
                                        p.payment_type_id = pt.payment_type_id AND
                                        p.booking_id = x.booking_id

                                    GROUP BY p.booking_id
                                ), 0
                            ) + x.balance_without_forecast
                        ), 0    
                    ) as charge_total,
                    IFNULL(
                        (
                            SELECT SUM(p.amount) as payment_total
                            FROM payment as p, payment_type as pt
                            WHERE
                                p.is_deleted = '0' AND
                                pt.is_deleted = '0' AND
                                p.payment_type_id = pt.payment_type_id AND
                                p.booking_id = x.booking_id
                                
                            GROUP BY p.booking_id
                        ), 0
                    ) as payment_total";
        
        if (isset($filters['not_include_charge_payment_total']) && $filters['not_include_charge_payment_total']) 
        {
            $include_charge_payment_total = "";
        }
        
        $external_select_customer_type = $select_customer_type = $join_customer_type = "";
        if (isset($filters['include_customer_type']) && $filters['include_customer_type']) 
        {
            $external_select_customer_type = "x.customer_type_name, 
                                            x.adult_count, 
                                            x.children_count, 
                                            x.value,
                                            x.custom_field_value,
                                            x.staying_customer_id,";
            
            $select_customer_type = "ct.name as customer_type_name, 
                                    b.adult_count,
                                    b.children_count,
                                    cxcf.value,
                                    GROUP_CONCAT(DISTINCT cxcf2.value, ' ') as custom_field_value,
                                    GROUP_CONCAT(DISTINCT sg.customer_id, ' ') as staying_customer_id,";
            
            $join_customer_type = "LEFT JOIN customer_type as ct ON ct.id = c.customer_type_id
                    LEFT JOIN customer_x_customer_field as cxcf ON cxcf.customer_id = b.booking_customer_id AND b.booking_customer_id != '0'
                    LEFT JOIN customer_fields as cf ON cxcf.customer_field_id = cf.id
                    LEFT JOIN customer_x_customer_field as cxcf2 ON cxcf2.customer_field_id = cf.id AND bscl.customer_id = sg.customer_id AND cxcf2.customer_id = sg.customer_id
                    ";
            
        }
        
        $external_select_customer_details = $select_customer_details = "";
        if($include_customer_all_details)
        {
            $external_select_customer_details = "x.email,
                                                x.phone,
                                                x.phone2,
                                                x.fax,
                                                x.address,
                                                x.address2,
                                                x.city,
                                                x.region,
                                                x.country,
                                                x.postal_code,";

            $select_customer_details = "c.email,
                                        c.phone,
                                        c.phone2,
                                        c.fax,
                                        c.address,
                                        c.address2,
                                        c.city,
                                        c.region,
                                        c.country,
                                        c.postal_code,";
        }

        $select_room_name_combine = " GROUP_CONCAT(room_name) ";
        if (isset($filters['fetch_checkindate_with_room_name']) && $filters['fetch_checkindate_with_room_name'])
        {
            $select_room_name_combine = " GROUP_CONCAT(CONCAT(room_name, '|$|', check_in_date)) ";
        }

        // SQL_CALC_FOUND_ROWS is used to calculate # of rows ignoring LIMIT. SELECT FOUND_ROWS() Must be called right after this query.
        // Which is called from get_found_rows() function.
        $sql = "
            SELECT SQL_CALC_FOUND_ROWS 
                *
            FROM
                (SELECT
                    x.booking_id,
                    x.customer_type_id,
                    $external_select_customer_type
                    x.booking_customer_id,
                    x.group_id,
                    x.room_id, 
                    x.r_room_type_id,
                    x.rate_plan_id,
                    x.check_in_date,
                    x.check_out_date,
                    x.room_name,
                    x.groups_id,
                    x.is_group_booking,
                    x.group_name,
                    x.state,
                    x.color,
                    x.rate,
                    x.balance,
                    x.balance_without_forecast,
                    x.pay_period,
                    x.charge_type_id,
                    x.use_rate_plan,
                    x.booking_notes,
                    $external_select_customer_details
                    x.customer_notes,
                    x.source,
                    IF(x.customer_name IS NULL, '', x.customer_name) as customer_name,
                    x.guest_count,
                    x.staying_customers,
                    x.guest_name,
                    x.brh_room_type_id
                    $include_charge_payment_total
                    $select_statements
                FROM
                (
                    SELECT 
                        b.booking_id,
                        b.is_ota_booking,
                        b.rate_plan_id,
                        up.first_name,
                        up.last_name,
                        bxs.group_id AS groups_id,
                        blg.id AS is_group_booking,
                        blg.name AS group_name,
                        brh.room_id,
                        brh.room_type_id as brh_room_type_id,
                        r.room_type_id as r_room_type_id,
                        (
                            /* Room name combine */
                            SELECT $select_room_name_combine FROM room
                            LEFT JOIN booking_block on room.room_id = booking_block.room_id
                            WHERE booking_id = b.booking_id
                            ORDER BY booking_block.check_in_date DESC
                        ) as room_name,
                        
                        min(check_in_date) as check_in_date,
                        max(check_out_date) as check_out_date,
                        (
                            SELECT r.group_id 
                            FROM room as r 
                            JOIN room_type as rt ON r.group_id=rt.id 
                            WHERE rt.acronym='SN' 
                            GROUP BY r.group_id 
                            order by r.group_id DESC
                            LIMIT 0,1
                        ) as group_id,
                        b.state,
                        b.color,
                        b.rate,
                        b.balance,
                        b.balance_without_forecast,
                        IF(b.source > 20, (SELECT bs.name FROM booking_source as bs WHERE bs.id = b.source LIMIT 1), b.source) as source,
                        b.pay_period,
                        b.charge_type_id,
                        b.use_rate_plan,
                        b.booking_notes,
                        b.booking_customer_id,
                        c.customer_type_id,
                        $select_customer_type
                        c.customer_name,
                        $select_customer_details
                        c.customer_notes,
                        count(DISTINCT sg.customer_id) as guest_count,
                        GROUP_CONCAT(DISTINCT sg.customer_name, ' ') as staying_customers,
                        (   SELECT c2.customer_name
                                FROM customer as c2, booking_staying_customer_list as bscl2
                                WHERE 
                                        c2.customer_id = bscl2.customer_id AND 
                                        bscl2.booking_id = b.booking_id
                                LIMIT 0,1
                        ) as guest_name
                        
                        $select_group_concat_statements
                    FROM booking as b
                    $booking_fields_join
                    LEFT JOIN booking_log as bl ON bl.booking_id = b.booking_id
                    LEFT JOIN user_profiles as up ON up.user_id = bl.user_id
                    LEFT JOIN booking_staying_customer_list as bscl ON bscl.booking_id = b.booking_id
                    LEFT JOIN customer as sg ON bscl.customer_id = sg.customer_id 
                    LEFT JOIN booking_block as brh ON brh.booking_id = b.booking_id AND brh.check_out_date = check_out_date
                    LEFT JOIN room as r ON brh.room_id = r.room_id 
                    LEFT JOIN customer as c ON c.customer_id = b.booking_customer_id AND b.booking_customer_id != '0'
                    $customer_fields_join
                    $join_customer_type
                    LEFT JOIN booking_x_group AS bxs ON bxs.booking_id = brh.booking_id 
                    LEFT JOIN booking_x_booking_linked_group AS bxblg ON bxblg.booking_id = brh.booking_id 
                    LEFT JOIN booking_linked_group AS blg ON blg.id = bxblg.booking_group_id
                    $join_statements
                    WHERE
                        $where_conditions
                        $where_booking_ids
                    $group_by

                )x
                $where_statements
            )y

            $where_condition_for_balance

            $order_by $order 
            
            $limit
        ";

        return $sql;
    }
    
    function _get_where_conditions($filters, $company_id, $include_room_no_assigned = false, $booking_fields_where_condition = "", $customer_fields_where_condition = "")
    {
        //Generate booking type portion of the SQL statement
        if (isset($filters['search_query']) && !isset($filters['state']) && !isset($filters['start_date']) && !isset($filters['end_date']))
        {
            $search_query = $filters['search_query'];
            $where_conditions = "
                c.customer_name like '%$search_query%' OR 
                sg.customer_name like '%$search_query%' OR 
                b.booking_notes like '%$search_query%' OR 
                b.booking_id like '%$search_query%' OR 
                c.phone like '%$search_query%' OR
                c.email like '%$search_query%' 
                $booking_fields_where_condition
                $customer_fields_where_condition
                ";
            return $where_conditions;
        }
        
        $state_sql = "";
        if (isset($filters['state'])) 
        {
            // SKIP THE CONDITION if filter applied for cancellation state
            if ($filters['state'] == 'active')  // Show all reservation, inhouse, and checkout guests. Called from calendar
            {
                if (!(isset($filters['reservation_type'])
                    && ($filters['reservation_type'] == CANCELLED || $filters['reservation_type'] == -1))) {
                    $state_sql = "AND (b.state < 4 OR b.state = '" . UNCONFIRMED_RESERVATION . "' OR b.state = '" . NO_SHOW . "')";
                }
            } 
            elseif ($filters['state'] == 'all' || $filters['state'] == '') 
            {
                $state_sql = "";
            } 
            else 
            {
                $state_sql = "AND b.state = '".$filters['state']."'";
            }
        }
        
        
                
        //Generate time portion of the SQL statement
        $time_sql = "";
        if(isset($filters['show_only_checked_in_and_checked_out']) && $filters['show_only_checked_in_and_checked_out']){
            if($filters['state'] == INHOUSE)
            {
                $time_sql = "AND (DATE(check_in_date) >= '".$filters['start_date']."' AND DATE(check_in_date) <= '".$filters['end_date']."')";
            }
            elseif ($filters['state'] == CHECKOUT)
            {
                $time_sql = "AND (DATE(check_out_date) >= '".$filters['start_date']."' AND DATE(check_out_date) <= '".$filters['end_date']."')";
            }
        }
        else
        {
            if(isset($filters['filter_booking_list']))
            {
                $start_date = isset($filters['filter_booking_list']['start_date']) ? $filters['filter_booking_list']['start_date'] : "";
                $end_date = isset($filters['filter_booking_list']['end_date']) ? $filters['filter_booking_list']['end_date'] : "";
                $date_overlap = isset($filters['filter_booking_list']['date_overlap']) ? $filters['filter_booking_list']['date_overlap'] : "";
                
                $time_sql = " AND ((DATE(check_in_date) = '".$start_date."' AND ".RESERVATION." = b.state) OR "
                                . " (DATE(check_out_date) = '".$end_date."' AND ".CHECKOUT." = b.state) OR "
                                #. " ('".$start_date."' BETWEEN DATE(check_in_date) AND DATE(check_out_date) AND ".UNCONFIRMED_RESERVATION." = b.state) OR "
                                . " ('".$start_date."' BETWEEN DATE(check_in_date) AND DATE(check_out_date) AND ".INHOUSE." = b.state) OR "
                                . " (".UNCONFIRMED_RESERVATION." = b.state) OR "
                                # " (".INHOUSE." = b.state) OR "
                                . " (DATE(check_out_date) > '".$date_overlap."' AND DATE(check_in_date) <= '".$date_overlap."' AND ".OUT_OF_ORDER." = b.state))";
            }
            else
            {
                // if both start_date and end_date are set, then return occupancies within range
                if (isset($filters['start_date']) && isset($filters['end_date']))
                { 
                    if ($filters['start_date'] != "" && $filters['end_date'] != "" && isset($filters['unassigned_bookings']) && $filters['unassigned_bookings'])
                    {
                        $time_sql = "AND (DATE(check_out_date) > '".$filters['start_date']."' AND '".$filters['end_date']."' > DATE(check_in_date))";
                    }
                    else if ($filters['start_date'] != "" && $filters['end_date'] != "") 
                    {
                        if(isset($filters['booking_status']) && $filters['booking_status'] == 'checking_in')
                        {
                            $time_sql = "AND (DATE(check_in_date) >= '".$filters['start_date']."' AND '".$filters['end_date']."' >= DATE(check_in_date))";
                        }
                        else if(isset($filters['booking_status']) && $filters['booking_status'] == 'checking_out')
                        {
                            $time_sql = "AND (DATE(check_out_date) >= '".$filters['start_date']."' AND '".$filters['end_date']."' >= DATE(check_out_date))";
                        }
                        else
                        {
                            $time_sql = "AND (DATE(check_out_date) >= '".$filters['start_date']."' AND '".$filters['end_date']."' >= DATE(check_in_date))";
                        }
                    }
                // if only start_date is set, then return occupancies that starts on start_date
                }
                elseif (isset($filters['start_date']) && !isset($filters['end_date'])) 
                { 
                    $time_sql = "AND DATE(check_in_date) = '".$filters['start_date']."'";
                // if only end_date is set, then return occupancies that ends on end_date
                } 
                elseif (!isset($filters['start_date']) && isset($filters['end_date'])) 
                { 
                    $time_sql = "AND DATE(check_out_date) = '".$filters['end_date']."'";
                }
            }
        }
        
        $date_overlap_sql = "";
        if (isset($filters['date_overlap']))
        { 
            $date_overlap_sql = "AND (DATE(check_in_date) <= '".$filters['date_overlap']."' AND DATE(check_out_date) > '".$filters['date_overlap']."')";
        }

        // matching customer_id
        $booking_customer_sql = "";
        if (isset($filters['booking_customer_id']))
        {
            $booking_customer_sql = "AND b.booking_customer_id = '".$filters['booking_customer_id']."'";
        }
        
        // matching customer_id
        $staying_customer_sql = $staying_customer_name = "";
        if (isset($filters['staying_customer_id']))
        {
            $staying_customer_sql = "AND 
                                        b.booking_id = bscl.booking_id AND
                                        bscl.customer_id = '".$filters['staying_customer_id']."'";
        }
        if(isset($filters['staying_guest_name']) && $filters['staying_guest_name'])
        {
            $staying_customer_name = "AND
                                       sg.customer_name like '%".$filters['staying_guest_name']."%' ";
        }
        // set search query
        $search_sql = "";
        if (isset($filters['search_query'])) 
        {
            $search_query = $filters['search_query'];
            $search_sql = "AND (
                c.customer_name like '%$search_query%' OR 
                sg.customer_name like '%$search_query%' OR 
                b.booking_notes like '%$search_query%' OR 
                b.booking_id like '%$search_query%' OR 
                c.phone like '%$search_query%' OR
                c.email like '%$search_query%' 
                $booking_fields_where_condition
                $customer_fields_where_condition
                )";     
        }
        
        $paid_sql = "";
        $where_conditions = "
            b.company_id = '$company_id' AND
            b.is_deleted != '1' AND 
            ".($include_room_no_assigned ? "IF(brh.room_id, r.is_deleted, '0')" : "r.is_deleted")." != '1'
            $time_sql
            $state_sql 
            $booking_customer_sql
            $staying_customer_sql
            $staying_customer_name
            $search_sql
            $paid_sql
            $date_overlap_sql
        ";
        
        if (isset($filters['location_id']) && $filters['location_id']) 
        {
            $where_conditions .= ' AND r.location_id="'.$filters['location_id'].'"';
        }
        if (isset($filters['floor_id']) && $filters['floor_id']) 
        {
            $where_conditions .= ' AND r.floor_id="'.$filters['floor_id'].'"';
        }  
        if (isset($filters['room_type_id']) && $filters['room_type_id']) 
        {
            $where_conditions .= ' AND r.room_type_id="'.$filters['room_type_id'].'"';
        }
        if (isset($filters['group_id']) && $filters['group_id']) 
        {
            $where_conditions .= ' AND r.group_id="'.$filters['group_id'].'"';

        }    
        if (isset($filters['reservation_type']) && $filters['reservation_type'] != '' && $filters['reservation_type'] != -1)
        {
            $where_conditions .= ' AND b.state="'.$filters['reservation_type'].'"';
        }         
        if (isset($filters['booking_source']) && $filters['booking_source'] != '') 
        {
            $where_conditions .= ' AND b.source="'.$filters['booking_source'].'"';
        } 
        
        if(isset($filters['group']) && $filters['group']){
            if($filters['group'] == 'all'){
                $where_conditions .= " ";
            }elseif($filters['group'] == 'unassigned'){
                $where_conditions .= " AND (bxs.group_id IS NULL OR bxs.group_id = 0) ";
            }
            else {
                $where_conditions .= " AND bxs.group_id = '".$filters['group']."' ";
            }
            
        }
        if (isset($filters['statement_date']) && $filters['statement_date'] != '') 
        {
            $where_conditions .= ' AND DATE(check_in_date) <= "'.$filters['statement_date'].'"';
        }
        if (isset($filters['group_ids']) && $filters['group_ids'])
        {
            $group_ids = trim(trim($filters['group_ids'], ","), " ");
            $where_conditions .= " AND blg.id IN ($group_ids) ";
        }
        return $where_conditions;
    }

    function get_csv_data($company_id, $booking_types, $date_start = null, $date_end = null)
    {
        $this->db->select("b.booking_id, bb.check_in_date, bb.check_out_date, r.room_name as room_name, c.customer_name, c.phone, IF(b.state = '".RESERVATION."', 'reservation', IF(b.state = '".INHOUSE."', 'in_house', IF(b.state = '".CHECKOUT."', 'checked_out', IF(b.state = '".UNCONFIRMED_RESERVATION."', 'unconfirmed', IF(b.state = '".CANCELLED."', 'cancelled', IF(b.state = '".OUT_OF_ORDER."', 'out of order', '')))))) as state", false);
        $this->db->from('booking as b');
        
        $this->db->join('booking_block as bb', 'bb.booking_id = b.booking_id','left');
        $this->db->join('customer as c', 'b.booking_customer_id = c.customer_id','left');
        $this->db->join('room as r', 'bb.room_id = r.room_id','left');

        $this->db->where("b.company_id", $company_id);
        $this->db->where("b.is_deleted = '0'");
        $this->db->where_in("b.state", $booking_types);
        if (isset($date_end))
        {
            $this->db->where('DATE(bb.check_in_date) <=', $date_end);
        }

        if (isset($date_start))
        {
            $this->db->where('DATE(bb.check_out_date) >=', $date_start);
        }
        
        $query = $this->db->get();
        return $query;
        
    }

    function get_csv_rate_plan_data($company_id, $rate_plan_id, $date_start = null, $date_end = null)
    {
        if($rate_plan_id != 'ota_rate_plan' && $rate_plan_id != 'select_all')
            $rate_plan_data = $this->get_rate_plan($rate_plan_id);

        // Main query select statements
        if($rate_plan_id == 'select_all'){
            $this->db->select("b.booking_id, bb.check_in_date, bb.check_out_date, b.adult_count, rp2.rate_plan_name");
        }
        else{
            $this->db->select('b.booking_id, bb.check_in_date, bb.check_out_date, b.adult_count');
        }

        // Main FROM clause with joins
        $this->db->from('booking AS b');
        $this->db->join('booking_block AS bb', 'bb.booking_id = b.booking_id', 'left');
        $this->db->join('customer AS c', 'b.booking_customer_id = c.customer_id', 'left');
        $this->db->join('room AS r', 'bb.room_id = r.room_id', 'left');
        $this->db->join('rate_plan AS rp2', 'rp2.rate_plan_id = b.rate_plan_id', 'left'); 

        if($rate_plan_id == 'select_all'){
            // Subquery as raw SQL
            $subquery = "
                SELECT b.booking_id
                FROM booking AS b
                LEFT JOIN booking_block AS bb ON bb.booking_id = b.booking_id
                LEFT JOIN rate_plan AS rp ON rp.rate_plan_id = b.rate_plan_id
                WHERE b.company_id = '{$company_id}'
                AND b.is_deleted = '0'
                AND DATE(bb.check_in_date) <= '{$date_end}'
                AND DATE(bb.check_out_date) >= '{$date_start}'
            ";

            // Use the subquery directly in the WHERE clause
            $this->db->where("b.booking_id IN ($subquery)", NULL, FALSE);
        }
        elseif($rate_plan_id != 'ota_rate_plan' && $rate_plan_id != 'select_all'){
            // Subquery as raw SQL
            $subquery = "
                SELECT b.booking_id
                FROM booking AS b
                LEFT JOIN booking_block AS bb ON bb.booking_id = b.booking_id
                LEFT JOIN rate_plan AS rp ON rp.rate_plan_id = b.rate_plan_id
                WHERE b.company_id = '{$company_id}'
                AND b.is_deleted = '0'
                AND rp.parent_rate_plan_id = '{$rate_plan_id}'
                AND DATE(bb.check_in_date) <= '{$date_end}'
                AND DATE(bb.check_out_date) >= '{$date_start}'
            ";

            // Use the subquery directly in the WHERE clause
            $this->db->where("b.booking_id IN ($subquery)", NULL, FALSE);
        } 
        elseif($rate_plan_id == 'ota_rate_plan') {
            // Subquery as raw SQL
            $subquery = "
                SELECT b.booking_id
                FROM booking AS b
                LEFT JOIN booking_block AS bb ON bb.booking_id = b.booking_id
                LEFT JOIN rate_plan AS rp ON rp.rate_plan_id = b.rate_plan_id
                WHERE b.company_id = '{$company_id}'
                AND b.is_deleted = '0'
                AND rp.rate_plan_name like '%ota%'
                AND DATE(bb.check_in_date) <= '{$date_end}'
                AND DATE(bb.check_out_date) >= '{$date_start}'
            ";

            // Use the subquery directly in the WHERE clause
            $this->db->where("b.booking_id IN ($subquery)", NULL, FALSE);
        }

        // Execute the query
        $query = $this->db->get();

        $result = $query->result_array();

        $adult_count = 0;
        foreach ($result as $key => $value) {
            $adult_count += $value['adult_count'];
        }

        // Check if the query executed successfully
        if (!$query) {
            // Log or return the error message
            $error = $this->db->error();
            log_message('error', 'Query Error: ' . $error['message']);
            return false;  // Ensure it returns `false` if there's an error
        }

        if($rate_plan_id == 'select_all'){
            $rate_plan_name = 'All Rate Plan';
        } elseif($rate_plan_id == 'ota_rate_plan'){
            $rate_plan_name = 'OTA Rate Plan';
        } else {
            $rate_plan_name = $rate_plan_data['rate_plan_name'];
        }
        
            return array('result' => $result, 'adult_count' => $adult_count, 'rate_plan_name' => $rate_plan_name);  // Return the valid query result object
    }

    function get_rate_plan($rate_plan_id)
    {
        $this->db->select("rp.*, r.*");
        $this->db->from("rate_plan as rp");
        $this->db->join("rate as r","rp.base_rate_id = r.rate_id", "left");
        $this->db->where("rp.is_deleted != '1'");
        $this->db->where("rp.rate_plan_id", $rate_plan_id);
        
        $query = $this->db->get();
        //echo $this->db->last_query();
        if ($this->db->_error_message()) // error checking
            show_error($this->db->_error_message());
        if ($query->num_rows >= 1) 
        {
            $q = $query->result_array();
            return $q[0];
        }
        return NULL;
    }
}
